﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

class Plane
{
    public Plane(string newIdentifier)
    {
        _identifier = newIdentifier;
    }

    public string Identifier
    {
        get { return _identifier; }
    }
    // Listing 3-19. Pole tylko do odczytu
    private readonly string _identifier;

    const double kilometersPerMile = 1.609344;

    public double SpeedInMilesPerHour
    {
        get
        {
            return SpeedInKilometersPerHour / kilometersPerMile;
        }
        set
        {
            // Pole tylko do odczytu niemożliwia nam napisanie instrukcji
            // o następującej postaci:
            //
            //  _identifier += ": prędkość zmodyfikowano do " + value;
            //
            // a zatem "chytry" programista musi teraz napisać
            // kod debugujący, który nie może modyfikować wartości 
            // właściwości:
            Console.WriteLine(Identifier + ": prędkość zmodyfikowano do " + value);
            SpeedInKilometersPerHour = value * kilometersPerMile;
        }
    }

    public double SpeedInKilometersPerHour
    {
        get;
        set;
    }
}